/*
 * Decompiled with CFR 0.152.
 */
package br.com.tangerino.connect.topdata.task;

import br.com.tangerino.connect.topdata.enums.Enumerators;
import br.com.tangerino.connect.topdata.task.AbstractBaseTask;
import com.jacob.com.Dispatch;
import java.util.logging.Logger;
import org.springframework.util.StringUtils;

public class ColetaPontoTask
extends AbstractBaseTask<String>
implements Runnable {
    private static final Logger log = Logger.getLogger(ColetaPontoTask.class.getName());
    private StringBuilder data = new StringBuilder();
    private Integer status = null;
    private int attemps = 0;
    private Integer received = 0;
    private boolean receivedLast = false;
    private String startDate;

    public ColetaPontoTask(String startDate) {
        this.startDate = startDate;
    }

    @Override
    public void run() {
        this.execute();
    }

    public String execute() {
        try {
            int result;
            if (!Enumerators.ParametrosComunicacao.SUCESSO.equals((Object)this.auth())) {
                String string = this.data.toString();
                return string;
            }
            if (this.getNsr() == null || this.getNsr() == 0) {
                this.setNsr(Integer.valueOf(1));
            }
            while (!this.receivedLast && (result = Dispatch.call((Dispatch)this.getComunicacao(), (String)"SolicitarRegistroNsr", (Object[])new Object[]{this.getNsr()}).getInt()) == Enumerators.InicioLeituraRegistroNsr.LEITURA_INICIADA.ordinal()) {
                this.status = Dispatch.call((Dispatch)this.getComunicacao(), (String)"LerStatusColeta").getInt();
                this.attemp();
                if (this.status.equals(Enumerators.StatusLeitura.FINALIZADA_COM_ULTIMO_REGISTRO.getValor()) || this.status.equals(Enumerators.StatusLeitura.FINALIZADA_COM_REGISTRO.getValor())) {
                    this.process();
                }
                if (this.status.equals(Enumerators.StatusLeitura.FINALIZADA_SEM_REGISTRO.getValor()) || this.status.equals(Enumerators.StatusLeitura.FINALIZADA_COM_ULTIMO_REGISTRO.getValor())) {
                    this.receivedLast = true;
                    continue;
                }
                this.setNsr(Integer.valueOf(this.getNsr() + 1));
            }
            this.getRep().setLastNsr(this.getNsr().intValue());
            Dispatch.call((Dispatch)this.getComunicacao(), (String)"FinalizarLeitura");
        }
        finally {
            this.getRep().setProcessing(false);
        }
        return this.data.toString();
    }

    private void attemp() {
        this.attemps = 0;
        while (this.status < Enumerators.StatusLeitura.FINALIZADA_COM_REGISTRO.getValor() && this.attemps < 10000) {
            try {
                Thread.sleep(100L);
                this.status = Dispatch.call((Dispatch)this.getComunicacao(), (String)"LerStatusColeta").getInt();
                ++this.attemps;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void process() {
        Integer n = this.received;
        Integer n2 = this.received = Integer.valueOf(this.received + 1);
        String registry = Dispatch.call((Dispatch)this.getComunicacao(), (String)"LerRegistroLinha").toString();
        if (StringUtils.isEmpty((Object)registry)) {
            return;
        }
        String tipo = registry.substring(9, 10);
        if ("3".equals(tipo)) {
            if (this.data.length() > 0) {
                this.data.append("\n");
            }
            this.data.append(registry);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColetaPontoTask)) {
            return false;
        }
        ColetaPontoTask other = (ColetaPontoTask)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        StringBuilder this$data = this.getData();
        StringBuilder other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        if (this.getAttemps() != other.getAttemps()) {
            return false;
        }
        Integer this$received = this.getReceived();
        Integer other$received = other.getReceived();
        if (this$received == null ? other$received != null : !((Object)this$received).equals(other$received)) {
            return false;
        }
        if (this.isReceivedLast() != other.isReceivedLast()) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        return !(this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColetaPontoTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        result = result * 59 + this.getAttemps();
        Integer $received = this.getReceived();
        result = result * 59 + ($received == null ? 43 : ((Object)$received).hashCode());
        result = result * 59 + (this.isReceivedLast() ? 79 : 97);
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        return result;
    }

    public StringBuilder getData() {
        return this.data;
    }

    public Integer getStatus() {
        return this.status;
    }

    public int getAttemps() {
        return this.attemps;
    }

    public Integer getReceived() {
        return this.received;
    }

    public boolean isReceivedLast() {
        return this.receivedLast;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setData(StringBuilder data) {
        this.data = data;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setAttemps(int attemps) {
        this.attemps = attemps;
    }

    public void setReceived(Integer received) {
        this.received = received;
    }

    public void setReceivedLast(boolean receivedLast) {
        this.receivedLast = receivedLast;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String toString() {
        return "ColetaPontoTask(data=" + this.getData() + ", status=" + this.getStatus() + ", attemps=" + this.getAttemps() + ", received=" + this.getReceived() + ", receivedLast=" + this.isReceivedLast() + ", startDate=" + this.getStartDate() + ")";
    }

    public ColetaPontoTask() {
    }
}

