/*
 * Decompiled with CFR 0.152.
 */
package br.com.tangerino.connect.topdata.service;

import br.com.tangerino.connect.base.model.entity.BaseEntity;
import br.com.tangerino.connect.base.service.BaseRepVendorService;
import br.com.tangerino.connect.client.TangerinoRestClient;
import br.com.tangerino.connect.model.dto.StatusSyncDTO;
import br.com.tangerino.connect.model.entity.EmployeeEntity;
import br.com.tangerino.connect.model.entity.EmployerEntity;
import br.com.tangerino.connect.model.entity.RepEntity;
import br.com.tangerino.connect.model.repository.EmployeeBiometricsRepository;
import br.com.tangerino.connect.model.repository.EmployeeRepository;
import br.com.tangerino.connect.model.repository.EmployerRepository;
import br.com.tangerino.connect.model.repository.RepRepository;
import br.com.tangerino.connect.service.BaseService;
import br.com.tangerino.connect.topdata.client.TopdataRepPlusClient;
import br.com.tangerino.connect.topdata.model.dto.InfoRepDTO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RepVendorService
extends BaseService<RepEntity>
implements BaseRepVendorService {
    private static final Logger log = LoggerFactory.getLogger(RepVendorService.class);
    private static final String ENVIANDO_FUNCIONARIO_PARA_O_REP = "Enviando colaborador para o REP: ";
    private static final String ENVIANDO_BIOMETRIA_PARA_O_REP = "Enviando BIO para o REP: ";
    @Autowired
    private TopdataRepPlusClient client;
    @Autowired
    private TangerinoRestClient tangerinoRestClient;
    @Autowired
    private RepRepository repository;
    @Autowired
    private EmployeeRepository employeeRepository;
    @Autowired
    private EmployerRepository employerRepository;
    @Autowired
    private EmployeeBiometricsRepository employeeBiometricsRepository;

    public StatusSyncDTO sync() {
        List reps = this.repository.findAllWhithoutTokenAndOnline();
        if (CollectionUtils.isEmpty((Collection)reps)) {
            return StatusSyncDTO.builder().message("Nenhum REP Encontrado! :(").build();
        }
        log.info("Foram encontrados " + reps.size() + " relogios");
        log.info("Buscando empregador...");
        List employers = this.employerRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)employers)) {
            return StatusSyncDTO.builder().message("Nenhum Empregador Encontrado! :(").build();
        }
        EmployerEntity employer = (EmployerEntity)employers.get(0);
        if (employer == null || employer.getId() == null) {
            return StatusSyncDTO.builder().message("Empregador nao localizado!").build();
        }
        log.info("Buscando lista de colaboradores...");
        List employees = this.employeeRepository.findAllWithPis();
        if (CollectionUtils.isEmpty((Collection)employees)) {
            return StatusSyncDTO.builder().message("Nenhum Colaborador Encontrado! :(").build();
        }
        log.info("Total de colaboradores: " + employees.size());
        ExecutorService executor = Executors.newFixedThreadPool(reps.size());
        for (RepEntity rep : reps) {
            Runnable worker = () -> {
                log.info(Thread.currentThread().getName() + " (Start) message = " + rep.getIp());
                this.syncRepLocal(employer, employees, rep);
                log.info(Thread.currentThread().getName() + " (End) message = " + rep.getIp());
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        log.info("Finished all threads");
        return StatusSyncDTO.builder().success(true).message("Sucesso!").build();
    }

    private void syncRepLocal(EmployerEntity employer, List<EmployeeEntity> employees, RepEntity rep) {
        try {
            log.info("Realizando Login no REP: " + rep.getIp());
            this.updateEmployer(rep, employer);
            this.syncEmployees(employees, rep);
            rep.setPort(Integer.valueOf(51000));
            Date now = new Date();
            rep.setLastSyncDate(now);
            this.save((BaseEntity)rep);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void syncEmployees(List<EmployeeEntity> employees, RepEntity rep) {
        List employeesRep = this.client.getEmployees(rep);
        for (EmployeeEntity employee : employees) {
            employee.setNickname(employee.getNickname());
            if (StringUtils.isEmpty((String)employee.getPassword())) {
                employee.setPassword(null);
            } else if (employee.getPassword().length() > 4) {
                employee.setPassword(employee.getPassword().substring(0, 3));
            }
            boolean alreadyExistsEmployeeWithPis = this.existsByPis(rep, employee.getPis(), employeesRep);
            if (employee.isFired() && alreadyExistsEmployeeWithPis && !this.isReadimitido(employee.getPis())) {
                this.removeEmployees(rep, employee);
                log.info("Removido Colaborador no rep");
                continue;
            }
            this.addUser(rep, employee);
            log.info("Cadastrando Colaborador no REP");
            if ((employee.isFired() || !StringUtils.isNotBlank((String)employee.getTemplate())) && !StringUtils.isNotBlank((String)employee.getTemplate2())) continue;
            this.updateUserBio(rep, employee);
            log.info("Atualizado Colaborador no rep");
        }
    }

    public boolean ping() {
        log.info("Iniciando verifica\u00e7\u00e3o dos REPs");
        List reps = this.repository.findAllWithoutToken();
        if (CollectionUtils.isEmpty((Collection)reps)) {
            log.warn("Nenhum REP Encontrado! :(");
            return false;
        }
        ExecutorService executor = Executors.newFixedThreadPool(reps.size());
        for (RepEntity rep : reps) {
            Runnable worker = () -> {
                log.info(Thread.currentThread().getName() + " (Start) message = " + rep.getIp());
                this.ping(rep);
                log.info(Thread.currentThread().getName() + " (End) message = " + rep.getIp());
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        log.info("Finished all threads");
        return true;
    }

    private void ping(RepEntity rep) {
        try {
            InfoRepDTO info = this.client.getInfo(rep);
            if (info != null && StringUtils.isNotBlank((String)info.getSerialNumber())) {
                rep.setSerialNumber(info.getSerialNumber());
                rep.setFwVersion(info.getFwVersion());
                rep.setBiometricModel(info.getBiometricModel());
                rep.setPublicKey(info.getPublicKey());
                rep.setLastCommunicationDate(new Date());
                rep.setStatus(true);
                this.save((BaseEntity)rep);
                this.tangerinoRestClient.updateRepStatus(rep);
            } else {
                rep.setStatus(false);
                this.save((BaseEntity)rep);
                this.tangerinoRestClient.updateRepStatus(rep);
                log.info("Falhou ao Conectar no REP - " + rep.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void updateEmployer(RepEntity rep, EmployerEntity employer) {
        try {
            log.info("Enviando empregador para o REP: " + rep.getIp() + " - " + employer.toString());
            this.client.saveEmployer(rep, employer);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isReadimitido(String pis) {
        return this.employeeRepository.checkIfIsReadmitted(pis) > 0L;
    }

    private void addUser(RepEntity rep, EmployeeEntity employee) {
        try {
            log.info(ENVIANDO_FUNCIONARIO_PARA_O_REP + rep.getIp() + " - " + employee.toString());
            this.client.createUser(rep, employee);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void updateUserBio(RepEntity rep, EmployeeEntity employee) {
        try {
            log.info(ENVIANDO_BIOMETRIA_PARA_O_REP + rep.getIp() + " - " + employee.toString());
            this.client.updateUser(rep, employee);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void removeEmployees(RepEntity rep, EmployeeEntity employee) {
        try {
            log.info(ENVIANDO_FUNCIONARIO_PARA_O_REP + rep.getIp() + " - " + employee.toString());
            this.client.deleteUser(rep, employee);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean existsByPis(RepEntity rep, String pis, List<EmployeeEntity> employeesRep) {
        try {
            log.info("Verificando Colaborador com PIS: " + pis + " no REP: " + rep.getIp());
            EmployeeEntity employee = this.client.getEmployee(rep, pis, employeesRep);
            return employee != null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public TopdataRepPlusClient getClient() {
        return this.client;
    }

    public TangerinoRestClient getTangerinoRestClient() {
        return this.tangerinoRestClient;
    }

    public RepRepository getRepository() {
        return this.repository;
    }

    public EmployeeRepository getEmployeeRepository() {
        return this.employeeRepository;
    }

    public EmployerRepository getEmployerRepository() {
        return this.employerRepository;
    }

    public EmployeeBiometricsRepository getEmployeeBiometricsRepository() {
        return this.employeeBiometricsRepository;
    }
}

