/*
 * Decompiled with CFR 0.152.
 */
package br.com.tangerino.connect.topdata.service;

import br.com.tangerino.connect.base.model.entity.BaseEntity;
import br.com.tangerino.connect.base.service.BaseEmployeeService;
import br.com.tangerino.connect.client.TangerinoRestClient;
import br.com.tangerino.connect.model.entity.EmployeeBiometricsEntity;
import br.com.tangerino.connect.model.entity.EmployeeEntity;
import br.com.tangerino.connect.model.entity.RepEntity;
import br.com.tangerino.connect.model.repository.EmployeeBiometricsRepository;
import br.com.tangerino.connect.model.repository.EmployeeRepository;
import br.com.tangerino.connect.model.repository.RepRepository;
import br.com.tangerino.connect.service.BaseService;
import br.com.tangerino.connect.topdata.client.TopdataRepPlusClient;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EmployeeService
extends BaseService<EmployeeEntity>
implements BaseEmployeeService {
    private static final Logger log = LoggerFactory.getLogger(EmployeeService.class);
    @Autowired
    private TangerinoRestClient tangerinoRestClient;
    @Autowired
    private TopdataRepPlusClient client;
    @Autowired
    private EmployeeRepository repository;
    @Autowired
    private EmployeeBiometricsRepository employeeBiometricsRepository;
    @Autowired
    private RepRepository repRepository;

    public boolean syncDataBaseEmployees() {
        log.info("Iniciando sincronizacao de colaboradores...");
        List employees = this.tangerinoRestClient.getAllUsers();
        if (CollectionUtils.isEmpty((Collection)employees)) {
            log.info("Lista de colaboradores esta vazia!");
            return false;
        }
        log.info("Percorrendo lista de colaboradores...");
        for (EmployeeEntity employee : employees) {
            try {
                EmployeeEntity entity = (EmployeeEntity)this.getById(employee.getId());
                if (entity != null && entity.getId() != null) {
                    entity.setName(employee.getName());
                    entity.setPis(employee.getPis());
                    entity.setFired(employee.isFired());
                    log.info("Atualizando Dados do Colaborador:" + employee.toString());
                    this.save((BaseEntity)entity);
                    continue;
                }
                employee.setRfid("0");
                employee.setBars("00");
                employee.setRepCode(Long.valueOf(0L));
                employee.setPassword("0000");
                employee.setKeyboardPassword("0000");
                log.info("Inserindo Dados do Colaborador:" + employee.toString());
                this.save((BaseEntity)employee);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.info("Nao foi possivel inserir ou alterar colaborador: " + e.getMessage());
                return false;
            }
        }
        log.info("Finalizado sincronizacao de colaboradores!");
        return true;
    }

    public void getEmployeesInfoFromRep() {
        log.info("Iniciando sincronizacao de templates do REP...");
        List reps = this.repRepository.findAllWhithoutTokenAndOnline();
        if (CollectionUtils.isEmpty((Collection)reps)) {
            log.warn("Nenhum REP Encontrado! :(");
            return;
        }
        List employees = this.repository.findAllWithPisAndNotFired();
        if (employees.isEmpty()) {
            log.info("Lista de colaboradores est\u00e1 vazia!");
            return;
        }
        log.info("Foram encontrados " + employees.size() + " colaboradores!");
        log.info(employees.toString());
        ExecutorService executor = Executors.newFixedThreadPool(reps.size());
        for (RepEntity rep : reps) {
            Runnable worker = () -> {
                log.info(Thread.currentThread().getName() + " (Start) message = " + rep.getIp());
                this.client.recebeUsuariosBio(rep, employees);
                for (EmployeeEntity employee : employees) {
                    this.save((BaseEntity)employee);
                }
                log.info(Thread.currentThread().getName() + " (End) message = " + rep.getIp());
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        log.info("Finished all threads");
    }

    private void biometricsInfo(EmployeeEntity employee) {
        if (employee.getTemplates() == null) {
            log.info("Template nulo ou vazio");
            return;
        }
        for (String biometria : employee.getTemplates()) {
            if (this.employeeBiometricsRepository.checkIfTemplateExist(employee.getId(), biometria) > 0L) {
                log.info("Biometria ja cadastrada!!");
                continue;
            }
            log.info("Biometria n\u00e3o existe no banco");
            EmployeeBiometricsEntity novaBiometria = new EmployeeBiometricsEntity();
            novaBiometria.setTemplate(biometria);
            novaBiometria.setEmployeeId(employee.getId());
            this.employeeBiometricsRepository.save((Object)novaBiometria);
        }
    }

    public void updateEmployees() {
        log.info("Iniciando sincronizacao de templates no tangerino...");
        List employees = this.repository.findAllWithPis();
        if (employees.isEmpty()) {
            log.info("Lista de colaboradores esta vazia!");
            return;
        }
        log.info("Percorrendo lista de colaboradores com template...");
        for (EmployeeEntity employee : employees) {
            if (this.tangerinoRestClient.updateUser(employee)) {
                log.info("Colaborador atualizado no tangerino com sucesso!");
                continue;
            }
            log.error("Erro ao atualizar colaborador tangerino");
        }
    }

    public TangerinoRestClient getTangerinoRestClient() {
        return this.tangerinoRestClient;
    }

    public TopdataRepPlusClient getClient() {
        return this.client;
    }

    public EmployeeRepository getRepository() {
        return this.repository;
    }

    public EmployeeBiometricsRepository getEmployeeBiometricsRepository() {
        return this.employeeBiometricsRepository;
    }

    public RepRepository getRepRepository() {
        return this.repRepository;
    }
}

