/*
 * Decompiled with CFR 0.152.
 */
package br.com.tangerino.connect.topdata.service;

import br.com.tangerino.connect.Constants;
import br.com.tangerino.connect.base.model.entity.BaseEntity;
import br.com.tangerino.connect.base.service.BaseAfdService;
import br.com.tangerino.connect.client.TangerinoRestClient;
import br.com.tangerino.connect.model.dto.StatusAndNsrDTO;
import br.com.tangerino.connect.model.dto.StatusSyncDTO;
import br.com.tangerino.connect.model.entity.RepEntity;
import br.com.tangerino.connect.service.RepService;
import br.com.tangerino.connect.topdata.client.TopdataRepPlusClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AfdService
implements BaseAfdService {
    private static final Logger log = LoggerFactory.getLogger(AfdService.class);
    private static final String SUCCESS = "Sucesso!";
    private static final String REGEX = "(\\d{9})3([0-3]\\d[0-1]\\d20[1-2]\\d[0-2]\\d[0-5]\\d)(\\d{11,12})";
    private static final int GROUP_DATA = 2;
    @Autowired
    private TangerinoRestClient tangerinoRestClient;
    @Autowired
    private RepService repService;
    @Autowired
    private TopdataRepPlusClient client;

    public StatusSyncDTO getAfds(boolean all) {
        List reps = this.repService.getRepository().findAllWhithoutTokenAndOnline();
        if (CollectionUtils.isEmpty((Collection)reps)) {
            return StatusSyncDTO.builder().message("Lista de REPs esta vazia!").build();
        }
        log.info("Foram encontrados " + reps.size() + " relogios");
        log.info("Percorrendo lista de REPs...");
        StatusSyncDTO status = StatusSyncDTO.builder().success(true).message("Sucesso!").build();
        ExecutorService executor = Executors.newFixedThreadPool(reps.size());
        for (RepEntity rep : reps) {
            Runnable worker = () -> {
                log.info(Thread.currentThread().getName() + " (Start) message = " + rep.getIp());
                this.getAfd(all, status, rep);
                log.info(Thread.currentThread().getName() + " (End) message = " + rep.getIp());
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        log.info("Finished all threads");
        return status;
    }

    private void getAfd(boolean allAFD, StatusSyncDTO status, RepEntity rep) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String path = Constants.TANGERINO_CONNECTION_AFDS + "AFD_" + rep.getId() + "_" + sdf.format(new Date()) + ".txt";
            if (StringUtils.isEmpty((Object)rep.getIp())) {
                log.info("REP esta sem IP Preenchido:" + rep.toString());
                return;
            }
            log.info("Buscando AFDs...");
            String afd = allAFD ? this.client.getFullAfd(rep) : this.client.getAfd(rep, Integer.valueOf(rep.getLastNsrSync()));
            if (StringUtils.isEmpty((Object)afd)) {
                log.error("AFD em branco");
                return;
            }
            Date checkDate = AfdService.tryParseDate((String)"010720200000");
            StringBuilder afdt = new StringBuilder();
            Pattern pattern = Pattern.compile("(\\d{9})3([0-3]\\d[0-1]\\d20[1-2]\\d[0-2]\\d[0-5]\\d)(\\d{11,12})", 8);
            Matcher matcher = pattern.matcher(afd);
            log.info("Buscando pontos a partir de uma data...");
            while (matcher.find()) {
                Date data = AfdService.tryParseDate((String)matcher.group(2));
                assert (data != null);
                if (!data.after(checkDate)) continue;
                afdt.append(matcher.group()).append("\n");
            }
            if (StringUtils.isEmpty((Object)afdt)) {
                log.error("Nenhum ponto encontrado a partir da data 01/07/2020!!");
                return;
            }
            log.info("Criando arquivo no caminho " + path);
            this.writeAdfFile(status, rep.getSerialNumber(), afdt.toString(), path);
            log.info("Salvando data do AFD local");
            rep.setLocalAfdDate(new Date());
            this.repService.save((BaseEntity)rep);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            status.setSuccess(false);
            status.setMessage("Error " + e.getMessage());
        }
    }

    private void writeAdfFile(StatusSyncDTO status, String serialNumber, String afd, String path) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(path));){
            bw.write("SERIAL_NUMBER:" + serialNumber);
            bw.newLine();
            bw.write(afd);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            status.setSuccess(false);
            status.setMessage("IOException " + e.getMessage());
        }
    }

    public StatusSyncDTO sendAfds() {
        StatusSyncDTO status = StatusSyncDTO.builder().message("Sucesso!").success(true).build();
        try {
            File pathFile = new File(Constants.TANGERINO_CONNECTION_AFDS);
            Object[] files = pathFile.listFiles(File::isFile);
            if (ArrayUtils.isEmpty((Object[])files)) {
                return StatusSyncDTO.builder().message("lista de arquivos vazia!!").build();
            }
            for (Object file : files) {
                if (((File)file).length() > 900000L) {
                    log.warn("N\u00e3o \u00e9 possivel enviar " + ((File)file).getName() + ", arquivo muito grande");
                    continue;
                }
                StatusAndNsrDTO response = this.tangerinoRestClient.sendAfd((File)file);
                if (response.isSuccess()) {
                    try {
                        log.info("Envio de AFDs com sucesso!");
                        log.info("Movendo para Backup: " + ((File)file).getName());
                        Files.move(Paths.get(((File)file).getPath(), new String[0]), Paths.get(Constants.TANGERINO_CONNECTION_BACKUPS + ((File)file).getName(), new String[0]), new CopyOption[0]);
                        Long code = Long.valueOf(((File)file).getName().split("_")[1]);
                        RepEntity rep = (RepEntity)this.repService.getById(code);
                        log.info("Atualizando ultimo NSR enviado");
                        if (this.updateLastNrs(response, rep)) {
                            rep.setLastNsrSync(response.getLastSuccessNsr().intValue());
                        }
                        rep.setRemoteAfdDate(new Date());
                        this.repService.save((BaseEntity)rep);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        status.setSuccess(false);
                        status.setMessage("Falha ao mover arquivo!!");
                    }
                    continue;
                }
                status.setSuccess(false);
                status.setMessage("Falha ao enviar AFD ou  arquivo em BRANCO!!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.info("Pasta sem arquivo!!");
        }
        return status;
    }

    private boolean updateLastNrs(StatusAndNsrDTO response, RepEntity rep) {
        if (response != null && response.getLastSuccessNsr() != null) {
            return rep.getLastNsrSync() < response.getLastSuccessNsr();
        }
        return false;
    }

    public StatusSyncDTO eraseBackup() {
        try {
            File pathFile = new File(Constants.TANGERINO_CONNECTION_BACKUPS);
            Object[] files = pathFile.listFiles(File::isFile);
            if (ArrayUtils.isEmpty((Object[])files)) {
                return StatusSyncDTO.builder().message("lista de arquivos vazia!!").build();
            }
            for (Object file : files) {
                Date dateFile = new Date(((File)file).lastModified());
                long diffInMillis = new Date().getTime() - dateFile.getTime();
                int diffInDays = (int)TimeUnit.DAYS.convert(diffInMillis, TimeUnit.MILLISECONDS);
                if (diffInDays > 5) {
                    log.info("Documento tem mais de 5 dias");
                    log.info(((File)file).delete() ? "Arquivo Deletado" : "Falha ao tentar Deletar Arquivo!");
                    continue;
                }
                log.info("Documento tem menos de 5 dias");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return StatusSyncDTO.builder().message("Error: " + e.getMessage()).build();
        }
        return StatusSyncDTO.builder().success(true).message("Sucesso!").build();
    }

    private static Date tryParseDate(String value) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)value)) {
            try {
                return new SimpleDateFormat("ddMMyyyyHHmm").parse(value);
            }
            catch (ParseException e) {
                log.error("Fail on Date parse!");
            }
        }
        return null;
    }

    public TangerinoRestClient getTangerinoRestClient() {
        return this.tangerinoRestClient;
    }

    public RepService getRepService() {
        return this.repService;
    }

    public TopdataRepPlusClient getClient() {
        return this.client;
    }
}

