/*
 * Decompiled with CFR 0.152.
 */
package br.com.tangerino.connect.topdata.client;

import br.com.tangerino.connect.model.entity.EmployeeEntity;
import br.com.tangerino.connect.model.entity.EmployerEntity;
import br.com.tangerino.connect.model.entity.RepEntity;
import br.com.tangerino.connect.topdata.enums.Enumerators;
import br.com.tangerino.connect.topdata.model.dto.InfoRepDTO;
import br.com.tangerino.connect.topdata.task.AbstractBaseTask;
import br.com.tangerino.connect.topdata.task.ColetaPontoTask;
import br.com.tangerino.connect.topdata.task.EnviarEmpregadorTask;
import br.com.tangerino.connect.topdata.task.EnviarListaExclusaoEmpregadosTask;
import br.com.tangerino.connect.topdata.task.EnviarListaIndividualEmpregadosTask;
import br.com.tangerino.connect.topdata.task.EnviarUsuariosBioTask;
import br.com.tangerino.connect.topdata.task.ReceberUsuariosBioTask;
import br.com.tangerino.connect.topdata.task.SolicitarChavePublicaTask;
import br.com.tangerino.connect.topdata.task.SolicitarEmpregadosTask;
import br.com.tangerino.connect.topdata.task.SolicitarInformacoesRepTask;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TopdataRepPlusClient {
    private static final Logger log = LoggerFactory.getLogger(TopdataRepPlusClient.class);

    public void run(RepEntity rep, AbstractBaseTask<?> task) {
        if (!rep.isProcessing()) {
            rep.setProcessing(true);
            task.setRep(rep);
            task.setNsr(Integer.valueOf(rep.getLastNsr()));
            Thread thread = new Thread((Runnable)task);
            thread.setName(task.getClass().getSimpleName() + " : " + rep.getIp());
            thread.start();
        }
    }

    public <T> T execute(RepEntity rep, AbstractBaseTask<T> task) {
        if (!rep.isProcessing()) {
            rep.setProcessing(true);
            task.setRep(rep);
            task.setNsr(Integer.valueOf(rep.getLastNsr()));
            return (T)task.execute();
        }
        return null;
    }

    public void createUser(RepEntity rep, EmployeeEntity employee) {
        Enumerators.InclusaoEmpregado response = (Enumerators.InclusaoEmpregado)this.execute(rep, (AbstractBaseTask)new EnviarListaIndividualEmpregadosTask(Collections.singletonList(employee)));
        if (Enumerators.InclusaoEmpregado.SUCESSO.equals((Object)response)) {
            log.info("Colaborador cadastrado no REP");
        } else {
            log.info("Erro ao cadastrar: " + response);
        }
    }

    public void updateUser(RepEntity rep, EmployeeEntity employee) {
        Enumerators.InclusaoEmpregado response = (Enumerators.InclusaoEmpregado)this.execute(rep, (AbstractBaseTask)new EnviarUsuariosBioTask(employee));
        if (Enumerators.InclusaoEmpregado.SUCESSO.equals((Object)response)) {
            log.info("Colaborador atualizado no REP");
        } else {
            log.info("Erro ao atualizar: " + response);
        }
    }

    public void deleteUser(RepEntity rep, EmployeeEntity employee) {
        try {
            this.execute(rep, (AbstractBaseTask)new EnviarListaExclusaoEmpregadosTask(Collections.singletonList(employee)));
        }
        catch (Exception e) {
            log.info("Colaborador removido no REP");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void recebeUsuariosBio(RepEntity rep, List<EmployeeEntity> employees) {
        try {
            this.execute(rep, (AbstractBaseTask)new ReceberUsuariosBioTask(employees));
        }
        catch (Exception e) {
            log.info("Colaborador removido no REP");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public EmployeeEntity getEmployee(RepEntity rep, String pis, List<EmployeeEntity> employees) {
        if (!StringUtils.isEmpty((Object)pis)) {
            for (EmployeeEntity employee : employees) {
                if (!employee.getFormattedPis().equals(pis)) continue;
                return employee;
            }
        }
        log.info("Funcion\u00e1rio n\u00e3o cadastrado no rep: " + pis);
        return null;
    }

    public List<EmployeeEntity> getEmployees(RepEntity rep) {
        return (List)this.execute(rep, (AbstractBaseTask)new SolicitarEmpregadosTask());
    }

    public InfoRepDTO getInfo(RepEntity rep) {
        log.info("Buscando informa\u00e7\u00f5es do rel\u00f3gio - " + rep.toString());
        try {
            for (int attemps = 0; attemps < 6; ++attemps) {
                InfoRepDTO info = (InfoRepDTO)this.execute(rep, (AbstractBaseTask)new SolicitarInformacoesRepTask());
                if (info == null) continue;
                log.info("Busca efetuada no rel\u00f3gio - " + rep.toString() + " com sucesso!");
                String key = (String)this.execute(rep, (AbstractBaseTask)new SolicitarChavePublicaTask());
                info.setPublicKey(key);
                rep.setPublicKey(key);
                rep.setSerialNumber(info.getSerialNumber());
                rep.setBiometricModel(info.getBiometricModel());
                rep.setFwVersion(info.getFwVersion());
                return info;
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getAfd(RepEntity rep, Integer nsr) {
        try {
            if (nsr != null) {
                ColetaPontoTask task = new ColetaPontoTask();
                task.setNsr(Integer.valueOf(nsr + 1));
                return (String)this.execute(rep, (AbstractBaseTask)task);
            }
            String startDate = Calendar.getInstance().get(5) + (Calendar.getInstance().get(2) + 1) + Calendar.getInstance().get(1) + "";
            return (String)this.execute(rep, (AbstractBaseTask)new ColetaPontoTask(startDate));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getFullAfd(RepEntity rep) {
        return (String)this.execute(rep, (AbstractBaseTask)new ColetaPontoTask());
    }

    public void saveEmployer(RepEntity rep, EmployerEntity employer) {
        this.execute(rep, (AbstractBaseTask)new EnviarEmpregadorTask(employer));
    }
}

