/*
 * Decompiled with CFR 0.152.
 */
package tcpcom;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import tcpcom.Cache;

public class TcpServer {
    private Socket clientSocket;
    private ServerSocket serverSocket;
    private String host;
    private int port;
    private DataOutputStream os;
    private DataInputStream is;
    private Cache cache;
    private boolean receive;
    private boolean connected;

    public TcpServer() {
    }

    public TcpServer(int port) {
        this.port = port;
    }

    public boolean open() {
        return this.open(this.port);
    }

    public boolean open(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
            this.cache = new Cache();
            this.receive = true;
            this.startRead();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean disconnect() {
        try {
            this.receive = false;
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
            this.serverSocket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean sendData(char[] data) {
        try {
            if (this.os != null) {
                int i$ = 0;
                char[] arr$ = data;
                int len$ = arr$.length;
                if (i$ < len$) {
                    char chr = arr$[i$];
                    byte temp = (byte)(chr & 0xFF);
                    this.os.write(temp);
                    return true;
                }
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void startRead() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (TcpServer.this.receive) {
                        if (TcpServer.this.clientSocket == null) {
                            System.out.println("Aceitando cliente");
                            TcpServer.this.clientSocket = TcpServer.this.serverSocket.accept();
                            System.out.println("ok, iniciando leitura");
                            TcpServer.this.os = new DataOutputStream(TcpServer.this.clientSocket.getOutputStream());
                            TcpServer.this.is = new DataInputStream(TcpServer.this.clientSocket.getInputStream());
                        } else if (TcpServer.this.is != null) {
                            try {
                                byte[] temp = new byte[512];
                                int qtty = TcpServer.this.is.read(temp, 0, 512);
                                if (qtty < 0) {
                                    throw new IOException();
                                }
                                char[] data = new char[qtty];
                                for (int j = 0; j < qtty; ++j) {
                                    data[j] = (char)temp[j];
                                }
                                TcpServer.this.cache.writeCache(data);
                            }
                            catch (IOException e) {
                                System.out.println("Cliente desconectou");
                                TcpServer.this.clientSocket = null;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        Thread.sleep(5L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "startRead").start();
    }

    public int availableData() {
        try {
            return this.cache.availableData();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public char[] receiveData(int size) {
        try {
            return this.cache.readCache(size);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

