/*
 * Decompiled with CFR 0.152.
 */
package tcpcom;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;
import tcpcom.Cache;

public class TcpClient {
    private Socket socket;
    private String host;
    private int port;
    private int timeout;
    private DataOutputStream os;
    private DataInputStream is;
    private Cache cache;
    private boolean receive;
    private boolean connected;
    private static Logger log = Logger.getLogger(TcpClient.class);

    public TcpClient() {
    }

    public TcpClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.timeout = 3000;
    }

    public TcpClient(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public boolean connect() {
        log.debug((Object)"conectando");
        return this.connect(this.host, this.port, this.timeout);
    }

    public boolean connect(String host, int port, int timeout) {
        try {
            this.host = host;
            this.port = port;
            byte[] addr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
            InetAddress inetAddr = InetAddress.getByAddress(addr);
            InetSocketAddress socketAddr = new InetSocketAddress(host, port);
            log.debug((Object)("Conectando ao ip " + host + ":" + port));
            this.socket = new Socket();
            this.socket.connect(socketAddr, timeout);
            this.cache = new Cache();
            this.os = new DataOutputStream(this.socket.getOutputStream());
            this.is = new DataInputStream(this.socket.getInputStream());
            this.receive = true;
            log.debug((Object)"Iniciando thread de conex\u00e3o");
            this.startRead();
            this.connected = true;
            return true;
        }
        catch (SocketTimeoutException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return false;
    }

    public boolean disconnect() {
        try {
            this.receive = false;
            this.socket.close();
            this.connected = false;
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    public boolean sendData(char[] data) {
        try {
            if (this.os != null) {
                byte[] temp = new byte[data.length];
                int i = 0;
                for (char chr : data) {
                    temp[i] = (byte)(chr & 0xFF);
                    ++i;
                }
                this.os.write(temp);
                this.os.flush();
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return false;
    }

    private void startRead() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (TcpClient.this.receive) {
                        int i;
                        if (TcpClient.this.is != null && (i = TcpClient.this.is.available()) > 0) {
                            char[] temp = new char[i];
                            for (int j = 0; j < i; ++j) {
                                temp[j] = (char)(TcpClient.this.is.readByte() & 0xFF);
                            }
                            TcpClient.this.cache.writeCache(temp);
                        }
                        Thread.sleep(5L);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }, "startRead").start();
    }

    public int availableData() {
        try {
            return this.cache != null ? this.cache.availableData() : 0;
        }
        catch (Exception e) {
            log.error((Object)e);
            return 0;
        }
    }

    public char[] receiveData(int size) {
        try {
            return this.cache != null ? this.cache.readCache(size) : null;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

